/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.Disk;
import ags.disk.Drive;
import ags.script.Target;
import ags.script.Variable;
import java.io.IOException;
import java.io.InputStream;

public abstract class RWTS {
    private String RWTS_REPLACEMENT;
    private byte[] RWTS_SECTOR;
    private int RWTS_SIZE;
    private int[] signature;
    protected Disk disk;

    public RWTS() {
    }

    public RWTS(String driverName, int ... signature) throws IOException {
        this.readRWTS(driverName);
        this.signature = signature;
    }

    private void readRWTS(String driverName) throws IOException {
        Target gs = Target.getTarget("apple2gs_setup");
        String slot = Variable.getVariable("slot").getValue();
        this.RWTS_REPLACEMENT = gs != null && gs.isRunAlready() ? "ags/asm/" + driverName + "_gs_port" + slot + ".o" : "ags/asm/" + driverName + "_ssc_slot" + slot + ".o";
        InputStream data = ClassLoader.getSystemResourceAsStream(this.RWTS_REPLACEMENT);
        this.RWTS_SECTOR = new byte[data.available()];
        this.RWTS_SIZE = data.read(this.RWTS_SECTOR);
        System.out.println("Using RWTS " + this.RWTS_REPLACEMENT + ", length=" + this.RWTS_SIZE + " bytes");
        data.close();
    }

    public boolean matches(byte[] sector) {
        for (int i = 0; i < this.signature.length; ++i) {
            if ((byte)this.signature[i] == sector[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getReloactedRWTS(int targetAddress, byte[] sector) {
        int i;
        int targetLo = 0xFF & targetAddress;
        int targetHi = 0xFF & targetAddress >> 8;
        byte[] rwts = new byte[256];
        for (i = 0; i < 256 && i < sector.length; ++i) {
            rwts[i] = sector[i];
        }
        System.out.println("Relocating RWTS to " + Integer.toHexString(targetAddress));
        for (i = 0; i < this.RWTS_SIZE - this.RWTS_SECTOR[this.RWTS_SIZE - 1]; ++i) {
            rwts[i] = this.RWTS_SECTOR[i];
        }
        for (i = 0; i < this.RWTS_SECTOR[this.RWTS_SIZE - 1]; ++i) {
            int pos = 0xFF & this.RWTS_SECTOR[this.RWTS_SIZE - 2 - i];
            System.out.println("Offset " + Integer.toHexString(pos));
            int n = pos;
            rwts[n] = (byte)(rwts[n] + targetLo);
            int n2 = pos + 1;
            rwts[n2] = (byte)(rwts[n2] + (targetHi - 16));
        }
        return rwts;
    }

    public abstract CommandBlock parseCommandBlock(byte[] var1);

    abstract void advance(CommandBlock var1);

    abstract void finishRWTS(Drive var1, CommandBlock var2);

    protected boolean isLogicalSector() {
        return true;
    }

    public class CommandBlock {
        private int slot;
        private int drive;
        private Command command;
        private int sector;
        private int track;
        private int volume;
        private int bufferAddress;
        private int sectorCount = 1;
        private RWTS rwts;

        public CommandBlock(RWTS r) {
            this.rwts = r;
        }

        public int getSlot() {
            return this.slot;
        }

        public void setSlot(int slot) {
            this.slot = slot;
        }

        public int getDrive() {
            return this.drive;
        }

        public void setDrive(int drive) {
            this.drive = drive;
        }

        public Command getCommand() {
            return this.command;
        }

        public void setCommand(Command command) {
            this.command = command;
        }

        public int getSector() {
            return this.sector;
        }

        public void setSector(int sector) {
            this.sector = sector;
        }

        public int getTrack() {
            return this.track;
        }

        public void setTrack(int track) {
            this.track = track;
        }

        public int getVolume() {
            return this.volume;
        }

        public void setVolume(int volume) {
            this.volume = volume;
        }

        public int getBufferAddress() {
            return this.bufferAddress;
        }

        public void setBufferAddress(int bufferAddress) {
            this.bufferAddress = bufferAddress;
        }

        public int getSectorCount() {
            return this.sectorCount;
        }

        public void setSectorCount(int sectorCount) {
            this.sectorCount = sectorCount;
        }

        public void next() {
            --this.sectorCount;
            this.rwts.advance(this);
        }

        public boolean isLogicalSector() {
            return this.rwts.isLogicalSector();
        }

        void finishRWTS(Drive aThis) {
            this.rwts.finishRWTS(aThis, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        READ,
        WRITE,
        FORMAT;

    }
}

